<?php
/**
 * ===================================================================================
 * Teacher Login Page (Branded)
 * ===================================================================================
 */

require_once '../config.php';

if (isset($_SESSION['teacher_id'])) {
    header('Location: dashboard.php');
    exit();
}

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = filter_var(trim($_POST['email'] ?? ''), FILTER_VALIDATE_EMAIL);
    $password = $_POST['password'] ?? '';

    if (empty($email) || empty($password)) {
        $errors[] = "Email and password are required.";
    } else {
        try {
            $stmt = $pdo->prepare("SELECT id, full_name, password_hash FROM teachers WHERE email = ?");
            $stmt->execute([$email]);
            $teacher = $stmt->fetch();

            if ($teacher && password_verify($password, $teacher['password_hash'])) {
                session_regenerate_id(true);
                $_SESSION['teacher_id'] = $teacher['id'];
                $_SESSION['teacher_full_name'] = $teacher['full_name'];
                header('Location: dashboard.php');
                exit();
            } else {
                $errors[] = "Invalid email or password provided.";
            }
        } catch (PDOException $e) {
            $errors[] = "A database error occurred.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teacher Login - TTTEDDDEL</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&family=Baloo+2:wght@700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f0f9ff; }
    </style>
</head>
<body class="flex items-center justify-center min-h-screen p-4">
     <div class="w-full max-w-md">
        <div class="text-center mb-8">
            <h1 class="text-6xl font-bold text-red-600 tracking-widest font-sans">TTTEDDDEL</h1>
            <p class="text-sm font-semibold text-blue-800 mt-1">Teacher-Student Interactive System</p>
            <p class="text-sm text-blue-800">by Ele Infocomm Technologiess</p>
        </div>
        <div class="p-8 space-y-6 bg-white rounded-2xl shadow-lg">
            <h2 class="text-2xl font-bold text-center text-gray-700">Teacher Login</h2>

            <?php if (!empty($errors)): ?>
                <div class="p-4 text-sm text-red-800 bg-red-100 rounded-lg" role="alert">
                    <ul class="list-disc list-inside">
                        <?php foreach ($errors as $error): ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>

             <form action="login.php" method="POST" class="space-y-6">
                <div>
                    <label for="email" class="block mb-2 text-sm font-medium text-gray-700">Email Address</label>
                    <input type="email" name="email" id="email" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-teal-500 focus:border-teal-500 block w-full p-3" required>
                </div>
                <div>
                    <label for="password" class="block mb-2 text-sm font-medium text-gray-700">Password</label>
                    <input type="password" name="password" id="password" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-teal-500 focus:border-teal-500 block w-full p-3" required>
                </div>
                <button type="submit" class="w-full text-white bg-teal-600 hover:bg-teal-700 focus:ring-4 focus:outline-none focus:ring-teal-300 font-bold rounded-lg text-sm px-5 py-3 text-center transition-colors">Sign In</button>
            </form>
        </div>
    </div>
</body>
</html>
